﻿Imports System

Imports System.Collections.Generic
Imports System.Text
Imports OpenNETCF.Windows.Forms
Imports System.Windows.Forms
Imports Microsoft.WindowsCE.Forms

Namespace ComboBoxTextChangeVBSample
    Public Class ComboSubclass
        Inherits NativeWindow
        Private Const WM_COMMAND As Integer = &H111
        Private Const CBN_DROPDOWN As Integer = 7


        Public Event DropDown As EventHandler
        Public Event DropUp As EventHandler


        Private comboBox As ComboBox


        Public Sub New(ByVal comboBox As ComboBox, ByVal parent As Control)
            Me.comboBox = comboBox
            'Subclass parent form
            Me.AssignHandle(parent.Handle)
        End Sub

        Public Shared Function LowWord(ByVal val As UInteger) As UShort
            Return CUShort(val)
        End Function

        Public Shared Function HighWord(ByVal val As UInteger) As UShort
            Return CUShort((val >> 16))
        End Function

        Protected Overloads Overrides Sub WndProc(ByRef m As Message)
            If m.Msg = WM_COMMAND Then
                ' Make sure that's its our ComboBox
                If m.LParam = comboBox.Handle Then
                    ' Get the Message from the WParam
                    Dim notificationMessage As UShort = HighWord(CUInt(m.WParam))

                    ' Have we got the DropDown message?
                    If notificationMessage = CBN_DROPDOWN Then
                        ' Raise the event
                        RaiseEvent DropDown(comboBox, Nothing)
                    Else
                        ' Raise the event
                        RaiseEvent DropUp(comboBox, Nothing)
                    End If
                End If
            End If
            MyBase.WndProc(m)
        End Sub

    End Class

End Namespace
